<?php
/**
 * WooCommerce/Wordpress actions tab partial view.
 *
 * @package    Sms_Net_Gr
 * @subpackage Sms_Net_Gr/admin/partials
 * @author     smsnet.gr <info@smsnet.gr>
 * @link       https://www.smsnet.gr
 * @since      1.0.0
 *
 */
?>

<!-- ACTIONS TAB -->
<div id="actions" class="wrap metabox-holder columns-2 sms_net_gr-metaboxes hidden">

  <!-- NEW ORDER -->
  <div class="meta-box-sortables ui-sortable">
    <div class="postbox">
      <h2 class="hndle"><span><?php esc_attr_e( 'New Order', $this->plugin_name ); ?></span></h2><br>
      <div class="inside">
        <table>
          <tbody>
            <tr>
              <td class="label">
                <label><?php esc_attr_e( 'Send SMS on new order?', $this->plugin_name ); ?></label>
              </td>
              <td class="field">
                <select id="<?php echo $this->plugin_name; ?>-new-order-send-sms" name="<?php echo $this->plugin_name; ?>[new-order-send-sms]">
                	<option value="true"
                  <?php if( ! empty( $options['new-order-send-sms'] ) && "true" == $options['new-order-send-sms'] ) echo 'selected="selected"'?>><?php esc_attr_e( 'Yes', $this->plugin_name ); ?></option>
                	<option value="false"
                  <?php if( ! empty( $options['new-order-send-sms'] ) && "false" == $options['new-order-send-sms'] ) echo 'selected="selected"'?>><?php esc_attr_e( 'No', $this->plugin_name ); ?></option>
                </select>
                <i class="info-balloon" data-balloon="<?php esc_attr_e( 'Send SMS to customer on checkout?', $this->plugin_name  ); ?>" data-balloon-pos="right">?</i>
              </td>
              <td></td>
            </tr>
            <tr>
              <td class="label">
                <label><?php esc_attr_e( 'Sender *', $this->plugin_name ); ?></label>
              </td>
              <td class="field">
                <input id="<?php echo $this->plugin_name; ?>-new-order-sender" name="<?php echo $this->plugin_name; ?>[new-order-sender]" value="<?php if(!empty($options['new-order-sender'])) echo $options['new-order-sender']; ?>" type="text" placeholder="<?php esc_attr_e('Name', $this->plugin_name); ?>"/>
                <i class="info-balloon" data-balloon-length="large" data-balloon="<?php esc_attr_e( 'The SMS sender. You can enter upto 16 numeric or 11 alphanumeric characters. Nameσ over 16 numeric or 11 alphanumeric characters characters will be cut out', $this->plugin_name  ); ?>" data-balloon-pos="right">?</i>
              </td>
              <td></td>
            </tr>
            <tr>
              <td class="label">
                <label><?php esc_attr_e( 'Encoding', $this->plugin_name ); ?></label>
              </td>
              <td class="field">
                <select id="<?php echo $this->plugin_name; ?>-new-order-encoding" name="<?php echo $this->plugin_name; ?>[new-order-encoding]">
                	<option value="1"
                  <?php if( ! empty( $options['new-order-encoding'] ) && "1" == $options['new-order-encoding'] ) echo 'selected="selected"'?>><?php esc_attr_e( 'GSM', $this->plugin_name ); ?></option>
                	<option value="2"
                  <?php if( ! empty( $options['new-order-encoding'] ) && "2" == $options['new-order-encoding'] ) echo 'selected="selected"'?>><?php esc_attr_e( 'UCS', $this->plugin_name ); ?></option>
                </select>
                <i class="info-balloon" data-balloon-length="large" data-balloon="<?php esc_attr_e( 'The SMS encoding. GSM encoding = 157 characters per sms ( some special characters may count for 2 characters ). UCS = 67 characters per sms', $this->plugin_name  ); ?>" data-balloon-pos="right">?</i>
              </td>
              <td></td>
            </tr>
            <tr>
              <td class="label">
                <label><?php esc_attr_e( 'Message *', $this->plugin_name ); ?></label>
              </td>
              <td class="field">
                <textarea id="<?php echo $this->plugin_name; ?>-new-order-sms-text" name="<?php echo $this->plugin_name; ?>[new-order-sms-text]"  rows="10" class="all-options"
                          placeholder="<?php esc_attr_e('Thank you for placing your order with www.yourdomain.com. Your order ID is {order_id} and is currently being processed. Your Store.', $this->plugin_name ); ?>"><?php if(!empty($options['new-order-sms-text'])) echo $options['new-order-sms-text']; ?></textarea>
                <i class="info-balloon" data-balloon-length="large" data-balloon="<?php esc_attr_e( 'Your Message Content, (Max 918 characters. Text over 160 characters may incur multiple credit charges). Enter your default message. You can use {first_name} for Firstname, {last_name} for Lastname, {user_email} for EmailAddress, {total} for Order\'s Total Price, {currency_code} for the Currency, {order_id} for Order Number and {order_status} for the Order\'s Status.', $this->plugin_name  ); ?>"  data-balloon-pos="right">?</i>
              </td>
              <td></td>
            </tr>
            <tr>
              <td></td>
              <td id="new-order-counter"><span id="new-order-counter-char" class="counter">0</span>&nbsp;
                <span id="new-order-char-counter-text"><?php esc_attr_e( 'characters', $this->plugin_name  ); ?></span>
                &#40;<span id="new-order-counter-sms" class="counter">0&nbsp;</span><?php esc_attr_e( ' sms', $this->plugin_name  ); ?>&#41;
              </td>
            </tr>
          </tbody>
        </table>
      </div><!-- .inside -->
    </div><!-- .postbox -->
  </div><!-- .meta-box-sortables .ui-sortable -->

  <!-- ORDER STATUS -->
  <div class="meta-box-sortables ui-sortable">
    <div class="postbox">
      <h2 class="hndle"><span><?php esc_attr_e( 'Order Status', $this->plugin_name ); ?></span></h2><br>
      <div class="inside">
        <table>
          <tbody>
            <tr>
              <td class="label">
                <label><?php esc_attr_e( 'Send SMS on order status change?', $this->plugin_name ); ?></label>
              </td>
              <td class="field">
                <select id="<?php echo $this->plugin_name; ?>-order-status-send-sms" name="<?php echo $this->plugin_name; ?>[order-status-send-sms]">
                	<option value="true"
                  <?php if( ! empty( $options['order-status-send-sms'] ) && "true" == $options['order-status-send-sms'] ) echo 'selected="selected"'?>><?php esc_attr_e( 'Yes', $this->plugin_name ); ?></option>
                	<option value="false"
                  <?php if( ! empty( $options['order-status-send-sms'] ) && "false" == $options['order-status-send-sms'] ) echo 'selected="selected"'?>><?php esc_attr_e( 'No', $this->plugin_name ); ?></option>
                </select>
                <i class="info-balloon" data-balloon="<?php esc_attr_e( 'Send SMS to customer on order status change?', $this->plugin_name  ); ?>" data-balloon-pos="right">?</i>
              </td>
              <td></td>
            </tr>
            <tr>
              <td class="label">
                <label><?php esc_attr_e( 'Sender *', $this->plugin_name ); ?></label>
              </td>
              <td class="field">
                <input id="<?php echo $this->plugin_name; ?>-order-status-sender" name="<?php echo $this->plugin_name; ?>[order-status-sender]" value="<?php if(!empty($options['order-status-sender'])) echo $options['order-status-sender']; ?>" type="text" placeholder="<?php esc_attr_e('Name', $this->plugin_name); ?> "/>
                <i class="info-balloon" data-balloon-length="large" data-balloon="<?php esc_attr_e( 'The SMS sender. You can enter upto 16 numeric or 11 alphanumeric characters. Nameσ over 16 numeric or 11 alphanumeric characters characters will be cut out', $this->plugin_name  ); ?>" data-balloon-pos="right">?</i>
            </tr>
            <tr>
              <td class="label">
                <label><?php esc_attr_e( 'Encoding', $this->plugin_name ); ?></label>
              </td>
              <td class="field">
                <select id="<?php echo $this->plugin_name; ?>-order-status-encoding" name="<?php echo $this->plugin_name; ?>[order-status-encoding]">
                  <option value="1"
                  <?php if( ! empty( $options['order-status-encoding'] ) && "1" == $options['order-status-encoding'] ) echo 'selected="selected"'?>><?php esc_attr_e( 'GSM', $this->plugin_name ); ?></option>
                  <option value="2"
                  <?php if( ! empty( $options['order-status-encoding'] ) && "2" == $options['order-status-encoding'] ) echo 'selected="selected"'?>><?php esc_attr_e( 'UCS', $this->plugin_name ); ?></option>
                </select>
                <i class="info-balloon" data-balloon-length="large" data-balloon="<?php esc_attr_e( 'The SMS encoding. GSM encoding = 157 characters per sms ( some special characters may count for 2 characters ). UCS = 67 characters per sms', $this->plugin_name  ); ?>" data-balloon-pos="right">?</i>
              </td>
              <td></td>
            </tr>
            <tr>
              <td class="label">
                <label><?php esc_attr_e( 'Message *', $this->plugin_name ); ?></label>
              </td>
              <td class="field">
                <textarea id="<?php echo $this->plugin_name; ?>-order-status-sms-text" name="<?php echo $this->plugin_name; ?>[order-status-sms-text]" rows="10" class="all-options"
                          placeholder="<?php esc_attr_e('Your order # {order_id} has been marked as {order_status}. Thanks for shopping at www.yourdomain.com', $this->plugin_name ); ?>"><?php if(!empty($options['order-status-sms-text'])) echo $options['order-status-sms-text']; ?></textarea>
                <i class="info-balloon" data-balloon-length="large" data-balloon="<?php esc_attr_e( 'Your Message Content, (Max 918 characters. Text over 160 characters may incur multiple credit charges). Enter your default message. You can use {first_name} for Firstname, {last_name} for Lastname, {user_email} for EmailAddress, {total} for Order\'s Total Price, {currency_code} for the Currency, {order_id} for Order Number and {order_status} for the Order\'s Status.', $this->plugin_name  ); ?>" data-balloon-pos="right">?</i>
              </td>
              <td></td>
            </tr>
            <tr>
              <td></td>
              <td id="order-status-counter"><span id="order-status-counter-char" class="counter">0</span>&nbsp;
                <span id="order-status-char-counter-text"><?php esc_attr_e( 'characters', $this->plugin_name  ); ?></span>
                &#40;<span id="order-status-counter-sms" class="counter">0&nbsp;</span><?php esc_attr_e( ' sms', $this->plugin_name  ); ?>&#41;
              </td>
            </tr>
          </tbody>
        </table>
      </div><!-- .inside -->
    </div><!-- .postbox -->
  </div><!-- .meta-box-sortables .ui-sortable -->

  <!-- ADDIONAL NOTIFICATION SETTINGS -->
  <div class="meta-box-sortables ui-sortable">
    <div class="postbox">
      <h2 class="hndle"><span><?php esc_attr_e( 'Additional Notification Settings', $this->plugin_name ); ?></span></h2><br>
      <div class="inside">
        <table>
          <tbody>
            <tr>
              <td class="label">
                <label><?php esc_attr_e( 'Notify Admin?', $this->plugin_name ); ?></label>
              </td>
              <td class="field">
                <select id="<?php echo $this->plugin_name; ?>-admin-notify" name="<?php echo $this->plugin_name; ?>[admin-notify]">
                	<option value="true"
                  <?php if( ! empty( $options['admin-notify'] ) && "true" == $options['admin-notify'] ) echo 'selected="selected"'?>><?php esc_attr_e( 'Yes', $this->plugin_name ); ?></option>
                	<option value="false"
                  <?php if( ! empty( $options['admin-notify'] ) && "false" == $options['admin-notify'] ) echo 'selected="selected"'?>><?php esc_attr_e( 'No', $this->plugin_name ); ?></option>
                </select>
                <i class="info-balloon" data-balloon="<?php esc_attr_e( 'Select whether dminstrator will be notified', $this->plugin_name  ); ?>" data-balloon-pos="right">?</i>
              </td>
              <td></td>
            </tr>
            <tr>
              <td class="label">
                <label><?php esc_attr_e( 'Admin mobile No *', $this->plugin_name ); ?></label>
              </td>
              <td class="field">
                <input id="<?php echo $this->plugin_name; ?>-admin-mobile" name="<?php echo $this->plugin_name; ?>[admin-mobile]" value="<?php if(!empty($options['admin-mobile'])) echo $options['admin-mobile']; ?>" type="text" placeholder="<?php esc_attr_e('Mobile', $this->plugin_name); ?>"/>
                <i class="info-balloon" data-balloon="<?php esc_attr_e( 'The Administrator mobile phone number', $this->plugin_name  ); ?>" data-balloon-pos="right">?</i>
              </td>
            </tr>
            <tr>
              <td class="label">
                <label><?php esc_attr_e( 'Encoding', $this->plugin_name ); ?></label>
              </td>
              <td class="field">
                <select id="<?php echo $this->plugin_name; ?>-admin-notify-encoding" name="<?php echo $this->plugin_name; ?>[admin-notify-encoding]">
                  <option value="1"
                  <?php if( ! empty( $options['admin-notify-encoding'] ) && "1" == $options['admin-notify-encoding'] ) echo 'selected="selected"'?>><?php esc_attr_e( 'GSM', $this->plugin_name ); ?></option>
                  <option value="2"
                  <?php if( ! empty( $options['admin-notify-encoding'] ) && "2" == $options['admin-notify-encoding'] ) echo 'selected="selected"'?>><?php esc_attr_e( 'UCS', $this->plugin_name ); ?></option>
                </select>
                <i class="info-balloon" data-balloon-length="large" data-balloon="<?php esc_attr_e( 'The SMS encoding. GSM encoding = 157 characters per sms ( some special characters may count for 2 characters ). UCS = 67 characters per sms', $this->plugin_name  ); ?>" data-balloon-pos="right">?</i>
              </td>
              <td></td>
            </tr>

            <tr>
              <td></td>
              <td class="field">
                <input id="<?php echo $this->plugin_name; ?>-admin-notify-new-account" name="<?php echo $this->plugin_name; ?>[admin-notify-new-account]" type="checkbox"
                           value="<?php if(!empty($options['admin-notify-new-account']) && "true" == $options['admin-notify-new-account'] ) echo $options['admin-notify-new-account']; ?>"
                           <?php if( ! empty( $options['admin-notify-new-account'] ) && "true" == $options['admin-notify-new-account'] ) echo 'checked="checked"'?> /><?php esc_attr_e( 'Notify admin on new account registration', $this->plugin_name ); ?>
                <i class="info-balloon" data-balloon-length="large" data-balloon="<?php esc_attr_e( 'Check this box if you want the Administrator to be notified by SMS every time a new customer signs up', $this->plugin_name  ); ?>" data-balloon-pos="right">?</i>
              </td>
              <td></td>
            </tr>
            <tr>
              <td class="label">
                <label><?php esc_attr_e( 'New Account Message *', $this->plugin_name ); ?></label>
              </td>
              <td class="field">
                <textarea id="<?php echo $this->plugin_name; ?>-admin-notify-new-account-sms-text" name="<?php echo $this->plugin_name; ?>[admin-notify-new-account-sms-text]" rows="10" class="all-options"
                          placeholder="<?php esc_attr_e('New account registration: {first_name} {last_name}, email: {user_email}', $this->plugin_name ); ?>"><?php if(!empty($options['admin-notify-new-account-sms-text'])) echo $options['admin-notify-new-account-sms-text']; ?></textarea>
                <i class="info-balloon" data-balloon-length="large" data-balloon="<?php esc_attr_e( 'Your Message Content, (Max 918 characters. Text over 160 characters may incur multiple credit charges). Enter your default message. You can use {first_name} for Firstname, {last_name} for Lastname, {user_email} for EmailAddress, {total} for Order\'s Total Price, {currency_code} for the Currency, {order_id} for Order Number and {order_status} for the Order\'s Status.', $this->plugin_name  ); ?>" data-balloon-pos="right">?</i>
              </td>
              <td></td>
            </tr>
            <tr>
              <td></td>
              <td id="admin-notify-new-account-counter"><span id="admin-notify-new-account-counter-char" class="counter">0</span>&nbsp;
                <span id="admin-notify-new-account-char-counter-text"><?php esc_attr_e( 'characters', $this->plugin_name  ); ?></span>
                &#40;<span id="admin-notify-new-account-counter-sms" class="counter">0&nbsp;</span><?php esc_attr_e( ' sms', $this->plugin_name  ); ?>&#41;
              </td>
            </tr>
            <tr>
              <td></td>
              <td class="field">
                <input id="<?php echo $this->plugin_name; ?>-admin-notify-customer-checkout" name="<?php echo $this->plugin_name; ?>[admin-notify-customer-checkout]" type="checkbox"
                           value="<?php if(!empty($options['admin-notify-customer-checkout']) && "true" == $options['admin-notify-customer-checkout'] ) echo $options['admin-notify-customer-checkout'];  ?>"
                           <?php if( ! empty( $options['admin-notify-customer-checkout'] ) && "true" == $options['admin-notify-customer-checkout'] ) echo 'checked="checked"'?> /><?php esc_attr_e( 'Notify admin when customer checkouts', $this->plugin_name ); ?>
                <i class="info-balloon" data-balloon-length="large" data-balloon="<?php esc_attr_e( 'Check this box if you want the Administrator to be notified by SMS every time a customer checks out', $this->plugin_name  ); ?>" data-balloon-pos="right">?</i>
              </td>
              <td></td>
            </tr>
            <tr>
              <td class="label">
                <label><?php esc_attr_e( 'Customer Checkout Message *', $this->plugin_name ); ?></label>
              </td>
              <td class="field">
                <textarea id="<?php echo $this->plugin_name; ?>-admin-notify-customer-checkout-sms-text" name="<?php echo $this->plugin_name; ?>[admin-notify-customer-checkout-sms-text]" rows="10" class="all-options"
                          placeholder="<?php esc_attr_e('{first_name} {last_name} (email: {user_email}) has placed an order (id: {order_id}) with amount {total} {currency_code}', $this->plugin_name ); ?>"><?php if(!empty($options['admin-notify-customer-checkout-sms-text'])) echo $options['admin-notify-customer-checkout-sms-text']; ?></textarea>
                <i class="info-balloon" data-balloon-length="large" data-balloon="<?php esc_attr_e( 'Your Message Content, (Max 918 characters. Text over 160 characters may incur multiple credit charges). Enter your default message. You can use {first_name} for Firstname, {last_name} for Lastname, {user_email} for EmailAddress, {total} for Order\'s Total Price, {currency_code} for the Currency, {order_id} for Order Number and {order_status} for the Order\'s Status.', $this->plugin_name  ); ?>" data-balloon-pos="right">?</i>
              </td>
              <td></td>
            </tr>
            <tr>
              <td></td>
              <td id="admin-notify-customer-checkout-counter"><span id="admin-notify-customer-checkout-counter-char" class="counter">0</span>&nbsp;
                <span id="admin-notify-customer-checkout-counter-text"><?php esc_attr_e( 'characters', $this->plugin_name  ); ?></span>
                &#40;<span id="admin-notify-customer-checkout-counter-sms" class="counter">0&nbsp;</span><?php esc_attr_e( ' sms', $this->plugin_name  ); ?>&#41;
              </td>
            </tr>
            <tr>
              <td></td>
              <td class="field">
                <input id="<?php echo $this->plugin_name; ?>-admin-notify-order-status" name="<?php echo $this->plugin_name; ?>[admin-notify-order-status]" type="checkbox"
                           value="<?php if(!empty($options['admin-notify-order-status']) && "true" == $options['admin-notify-order-status'] ) echo $options['admin-notify-order-status']; ?>"
                           <?php if( ! empty( $options['admin-notify-order-status'] ) && "true" == $options['admin-notify-order-status'] ) echo 'checked="checked"'?> /><?php esc_attr_e( 'Notify admin when order status changes', $this->plugin_name ); ?>
                <i class="info-balloon" data-balloon-length="large" data-balloon="<?php esc_attr_e( 'Check this box if you want the Administrator to be notified by SMS every time an order status is changed', $this->plugin_name  ); ?>" data-balloon-pos="right">?</i>
              </td>
              <td></td>
            </tr>
            <tr>
              <td class="label">
                <label><?php esc_attr_e( 'Order Status Change Message *', $this->plugin_name ); ?></label>
              </td>
              <td class="field">
                <textarea id="<?php echo $this->plugin_name; ?>-admin-notify-order-status-sms-text" name="<?php echo $this->plugin_name; ?>[admin-notify-order-status-sms-text]" rows="10" class="all-options"
                          placeholder="<?php esc_attr_e("{first_name} {last_name}'s (email: {user_email}) order (id: {order_id}) has changed to {order_status}", $this->plugin_name ); ?>"><?php if(!empty($options['admin-notify-order-status-sms-text'])) echo $options['admin-notify-order-status-sms-text']; ?></textarea>
                <i class="info-balloon" data-balloon-length="large" data-balloon="<?php esc_attr_e( 'Your Message Content, (Max 918 characters. Text over 160 characters may incur multiple credit charges). Enter your default message. You can use {first_name} for Firstname, {last_name} for Lastname, {user_email} for EmailAddress, {total} for Order\'s Total Price, {currency_code} for the Currency, {order_id} for Order Number and {order_status} for the Order\'s Status.', $this->plugin_name  ); ?>" data-balloon-pos="right">?</i>
              </td>
              <td></td>
            </tr>
            <tr>
              <td></td>
              <td id="admin-notify-order-status-counter"><span id="admin-notify-order-status-counter-char" class="counter">0</span>&nbsp;
                <span id="admin-notify-order-status-counter-text"><?php esc_attr_e( 'characters', $this->plugin_name  ); ?></span>
                &#40;<span id="admin-notify-order-status-counter-sms" class="counter">0&nbsp;</span><?php esc_attr_e( ' sms', $this->plugin_name  ); ?>&#41;
              </td>
            </tr>
          </tbody>
        </table>
      </div><!-- .inside -->
    </div><!-- .postbox -->
  </div><!-- .meta-box-sortables .ui-sortable -->

</div><!-- #actions -->
