/**
 * Javascript to handle the woocommerce actions
 *
 * @package    Sms_Net_Gr
 * @subpackage Sms_Net_Gr/api/js
 * @link       https://www.smsnet.gr
 * @author     smsnet.gr <info@smsnet.gr>
 * @since 1.0.0
 */

if (typeof(console) == 'object') {
	console.log('actions script loaded');
}

// Document ready
(function($) {
	//New order encoding select box
	jQuery('#sms_net_gr-new-order-encoding').on('change',function() {
		var length = char_count(this.value, jQuery('#sms_net_gr-new-order-sms-text').val());
		set_counters('#new-order-counter-char', '#new-order-counter-sms', this.value, length);
	});

	// New order SMS text keyup handler
	jQuery('#sms_net_gr-new-order-sms-text').keyup(function() {
			jQuery("#new-order-counter").slideDown(200);
			var length = char_count(jQuery('#sms_net_gr-new-order-encoding').val(), this.value);
			set_counters('#new-order-counter-char', '#new-order-counter-sms', this.value, length);
	});

	//New order encoding select box
	jQuery('#sms_net_gr-order-status-encoding').on('change',function() {
		var length = char_count(this.value, jQuery('#sms_net_gr-order-status-sms-text').val());
		set_counters('#order-status-counter-char', '#order-status-counter-sms', this.value, length);
	});

	// New order SMS text keyup handler
	jQuery('#sms_net_gr-order-status-sms-text').keyup(function() {
			jQuery("#order-status-counter").slideDown(200);
			var length = char_count(jQuery('#sms_net_gr-order-status-encoding').val(), this.value);
			set_counters('#order-status-counter-char', '#order-status-counter-sms', this.value, length);
	});

	//Admin notify on new account encoding select box
	jQuery('#sms_net_gr-admin-notify-encoding').on('change',function() {
		var length = char_count(this.value, jQuery('#sms_net_gr-admin-notify-new-account-sms-text').val());
		set_counters('#admin-notify-new-account-counter-char', '#admin-notify-new-account-counter-sms', this.value, length);
	});

	// Admin notify on new account SMS text keyup handler
	jQuery('#sms_net_gr-admin-notify-new-account-sms-text').keyup(function() {
			jQuery("#admin-notify-new-account-counter").slideDown(200);
			var length = char_count(jQuery('#sms_net_gr-admin-notify-encoding').val(), this.value);
			set_counters('#admin-notify-new-account-counter-char', '#admin-notify-new-account-counter-sms', this.value, length);
	});

	// Admin notify on customer checkout encoding select box
	jQuery('#sms_net_gr-admin-notify-encoding').on('change',function() {
		jQuery("#admin-notify-customer-checkout-counter").slideDown(200);
		var length = char_count(this.value, jQuery('#sms_net_gr-admin-notify-customer-checkout-sms-text').val());
		set_counters('#admin-notify-customer-checkout-counter-char', '#admin-notify-customer-checkout-counter-sms', this.value, length);
	});

	// Admin notify on customer checkout SMS text keyup handler
	jQuery('#sms_net_gr-admin-notify-customer-checkout-sms-text').keyup(function() {
			jQuery("#admin-notify-customer-checkout-counter").slideDown(200);
			var length = char_count(jQuery('#sms_net_gr-admin-notify-encoding').val(), this.value);
			set_counters('#admin-notify-customer-checkout-counter-char', '#admin-notify-customer-checkout-counter-sms', this.value, length);
	});

	// Admin notify on order status change encoding select box
	jQuery('#sms_net_gr-admin-notify-encoding').on('change',function() {
		var length = char_count(this.value, jQuery('#sms_net_gr-admin-notify-order-status-sms-text').val());
		set_counters('#admin-notify-order-status-counter-char', '#admin-notify-order-status-counter-sms', this.value, length);
	});

	// Admin notify on order status change SMS text keyup handler
	jQuery('#sms_net_gr-admin-notify-order-status-sms-text').keyup(function() {
			jQuery("#admin-notify-order-status-counter").slideDown(200);
			var length = char_count(jQuery('#sms_net_gr-admin-notify-encoding').val(), this.value);
			set_counters('#admin-notify-order-status-counter-char', '#admin-notify-order-status-counter-sms', this.value, length);
	});


})(jQuery);
