/**
 * Javascript to handle the get-key action
 *
 * @package    Sms_Net_Gr
 * @subpackage Sms_Net_Gr/api/js
 * @link       https://www.smsnet.gr
 * @author     smsnet.gr <info@smsnet.gr>
 * @since 1.0.0
 */

if (typeof(console) == 'object') {
	console.log( 'get-key script loaded' );
}

var params = sms_net_gr_get_key;
// Set validation Rules
var get_key_rules = {
		username: {
			required: true,
			messages: {
				required:  params.username_missing
			}
		},
		password: {
			required: true,
			messages: {
				required:  params.password_missing
			}
		}
};

// Document ready
(function($) {
	  // Get Key click handler
	  jQuery( '#get-key' ).click(function() {
				add_validation_rules(get_key_rules);
				// Get parameters enqueued by PHP
				if(jQuery( "#sms_net_gr").valid()) {
					var username = jQuery( '#username' ).val();
					var password = jQuery( '#password' ).val();
					// The data to post to admin-ajax.php
					var data = {
						action: 'get_key',
						username: username,
						password: password,
						reset: false
					};
					get_key(data, '#sms_net_gr-api-key', function() {
						return get_balance({action: 'get_balance'}, '#balance');
					});
				}
				remove_validation_rules(get_key_rules);
			});
})(jQuery);
