/**
 * Javascript to handle the reset-key action
 *
 * @package    Sms_Net_Gr
 * @subpackage Sms_Net_Gr/api/js
 * @link       https://www.smsnet.gr
 * @author     smsnet.gr <info@smsnet.gr>
 * @since 1.0.0
 */

if (typeof(console) == 'object') {
	console.log( 'reset-key script loaded' );
}

var params = sms_net_gr_reset_key;
// Set validation Rules
var reset_key_rules = {
		username: {
			required: true,
			messages: {
				required:  params.username_missing
			}
		},
		password: {
			required: true,
			messages: {
				required:  params.password_missing
			}
		}
};

// Document ready
(function($) {
	  // Reset Key click handler
	  jQuery( '#reset-key' ).click(function() {
				add_validation_rules(reset_key_rules);
				// Get parameters enqueued by PHP
				if(jQuery("#sms_net_gr").valid()) {
					var username = jQuery('#username').val();
					var password = jQuery('#password').val();
					// The data to post to admin-ajax.php
					var data = {
						action: 'get_key',
						username: username,
						password: password,
						reset: true
					};
					get_key(data, '#sms_net_gr-api-key', function() {
						return get_balance({action: 'get_balance'}, '#balance');
					});
				}
				remove_validation_rules(reset_key_rules);
			});
})(jQuery);
