/**
 * Javascript to handle the send-sms action
 *
 * @package    Sms_Net_Gr
 * @subpackage Sms_Net_Gr/api/js
 * @link       https://www.smsnet.gr
 * @author     smsnet.gr <info@smsnet.gr>
 * @since 1.0.0
 */

if (typeof(console) == 'object') {
	console.log('send-sms script loaded');
}

// Get parameters enqueued by PHP
var params = sms_net_gr_send_sms;

// Set validation rules
var send_sms_rules = {
	sender: {
		required: {
			depends: function() {
				var value = jQuery('#sender').val();
				if(value !== null) {
					jQuery('#sender').val(value.check_sender_id());
					return true;
				} else {
					return false;
				}
			}
		},
		messages: {
			required: params.sender_missing
		}
	},
	recipient: {
		required: true,
		messages: {
			required: params.recipient_missing
		}
	},
	'send-sms-message': {
		required: true,
		maxlength: 918,
		messages: {
			required: params.message_missing,
			maxlength: params.message_too_long
		}
	}
};

// Document ready
(function($) {
	//Encoding select box
	jQuery('#send-sms-encoding').on('change',function() {
		var length = char_count(this.value, jQuery('#send-sms-message').val());
		set_counters('#send-sms-counter-char', '#send-sms-counter-sms', this.value, length);
	});

	// SMS text keyup handler
	jQuery('#send-sms-message').keyup(function() {
			jQuery("#send-sms-counter").slideDown(200);
			var length = char_count(jQuery('#send-sms-encoding').val(), jQuery('#send-sms-message').val());
			set_counters('#send-sms-counter-char', '#send-sms-counter-sms', jQuery('#send-sms-encoding').val(), length);
	});

	// Send SMS button click handler
	jQuery('#send-sms').click(function() {
			add_validation_rules(send_sms_rules);
	  	if(jQuery( "#sms_net_gr").valid()) {
				// The data to post to admin-ajax.php
				var data = {
					action: 'send_sms',
					from: jQuery('#sender').val(),
					to: jQuery('#recipient').val(),
					message: jQuery('#send-sms-message').val(),
					encoding: jQuery('#send-sms-encoding').val(),
					ajax: true
				};
				send_sms(data, function() {
					//return get_balance({action: 'get_balance'}, '#balance');
					return null;
				});
			}
			remove_validation_rules(send_sms_rules);
	});
})(jQuery);
