<?php
/**
 * Defines the internationalization functionality
 *
 * @package    Sms_Net_Gr
 * @subpackage Sms_Net_Gr/includes
 * @link       https://www.smsnet.gr
 * @author     smsnet.gr <info@smsnet.gr>
 * @since 1.0.0
 */

/**
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @package    Sms_Net_Gr
 * @subpackage Sms_Net_Gr/includes
 * @link       https://www.smsnet.gr
 * @author     smsnet.gr <info@smsnet.gr>
 * @since 1.0.0
 */
class Sms_Net_Gr_i18n {


	/**
	 * Load the plugin text domain for translation.
	 *
	 * @since    1.0.0
	 */
	public function load_plugin_textdomain() {

		load_plugin_textdomain(
			'sms_net_gr',
			false,
			dirname( dirname( plugin_basename( __FILE__ ) ) ) . '/languages/'
		);

		load_plugin_textdomain(
			'woocommerce',
			false,
			dirname(plugin_dir_path( __DIR__ )) . '/woocommerce/i18n/languages/'
		);
	}



}
