<?php
/**
 * The file that defines the uninstaller class
 *
 * @package    Sms_Net_Gr
 * @subpackage Sms_Net_Gr/includes
 * @link       https://www.smsnet.gr
 * @author     smsnet.gr <info@smsnet.gr>
 * @since 1.0.0
 */

 /**
  * The class responsible to provide basic database functionality to other classes that
  * inherit from it.
  */
 require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/model/class-sms-net-gr-base-model.php';

 /**
  * The class that manages the main plugin datbase table. This table stores sms history.
  */
 require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/model/class-sms-net-gr-model.php';

/**
 * The class that performs cleanup upon uninstallation
 *
 * This is used to  among others todelete the sms_net_gr database table
 *
 * @package    Sms_Net_Gr
 * @subpackage Sms_Net_Gr/includes
 * @link       https://www.smsnet.gr
 * @author     smsnet.gr <info@smsnet.gr>
 * @since 1.0.0
 */
class Sms_Net_Gr_Uninstaller {
	/**
	 * This function is used to delete database tables
	 *
	 * @return void
	 */
	public static function delete_database_tables() {
		/**
	 * Use Sms_Net_Gr_Model method delete_sms_net_gr_table
	 * to delete database tables
	 */
		Sms_Net_Gr_Model::instance()->delete_sms_net_gr_table();
	}
}
