<?php
/**
 * Implementation of the abstract Sms_Net_Gr_Helper_Base class.
 *
 * @package    Sms_Net_Gr
 * @subpackage Sms_Net_Gr/includes/helper
 * @link       https://www.smsnet.gr
 * @author     smsnet.gr <info@smsnet.gr>
 * @since 1.0.0
 */

/**
 * Defines a class that inherits from abstract class
 * Sms_Net_Gr_Helper_Base
 *
 * @package    Sms_Net_Gr
 * @subpackage Sms_Net_Gr/includes/helper
 * @author     smsnet.gr <info@smsnet.gr>
 * @since 1.0.0
 */

require_once dirname( __FILE__ ) . '/class-sms-net-gr-helper-base.php';

/**
 * Class Sms_Net_Gr_Helper inherits from Sms_Net_Gr_Helper_Base
 * and it is a singleton.
 *
 * @package    Sms_Net_Gr
 * @subpackage Sms_Net_Gr/includes
 * @author     smsnet.gr <info@smsnet.gr>
 * @since 1.0.0
 */
class Sms_Net_Gr_Helper extends Sms_Net_Gr_Helper_Base {
  /**
	 * The plugin instance
	 *
	 * @var Sms_Net_Gr_Helper instance
	 * @since 1.0.0
	 */
	private static $instance;

	/**
	 * Constructor
	 *
	 * @since 1.0.0
	 * @access private
	 * @return void
	 */
	protected function __construct() {
		parent::__construct();
	}

	/**
	 * Function instance
	 * This method makes sure that only one instance of
	 * this class exists in memory at any given time.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return Sms_Net_Gr_Helper
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) && ! ( self::$instance instanceof Sms_Net_Gr_Helper ) ) {
			self::$instance = new Sms_Net_Gr_Helper();
		}
		return self::$instance;
	}
}
