<?php
/**
 * The file that provides functionality to manage the main
 * plugin table which stores sms history
 *
 * @package    Sms_Net_Gr
 * @subpackage Sms_Net_Gr/includes/model
 * @link       https://www.smsnet.gr
 * @author     smsnet.gr <info@smsnet.gr>
 * @since 1.0.0
 */

/**
 *
 * It inherits basic datbase functionatlity from the abstract
 * class Sms_Net_Gr_Base_Model
 *
 * @package    Sms_Net_Gr
 * @subpackage Sms_Net_Gr/includes/model
 * @author     smsnet.gr <info@smsnet.gr>
 * @since 1.0.0
 */

require_once  dirname( __FILE__ ) . '/class-sms-net-gr-base-model.php';

/**
 * The class that manages the main Sms_Net_Gr database table
 *
 * This is used to create.delete the sms_net_gr datbase table
 *
 * @since      1.0.0
 * @package    Sms_Net_Gr
 * @subpackage Sms_Net_Gr/includes/model
 * @author     smsnet.gr <info@smsnet.gr>
 */
class Sms_Net_Gr_Model extends Sms_Net_Gr_Base_Model {
	/**
	 * Table Name constant
	 *
	 * @since 1.0.0
	 * @var string
	 */
	const TABLE_NAME = 'sms_net_gr';

	/**
	 * The plugin instance
	 *
	 * @var Sms_Net_Gr_Model instance
	 * @since	1.0.0
	 * @access	private
	 */
	private static $instance;

	/**
	 * Constructor
	 *
	 * @since 1.0.0
	 * @access private
	 * @return void
	 */
	private function __construct() {
		$this->set_table_name( self::TABLE_NAME );
	}

	/**
	 * Function instance
	 * This method makes sure that only one instance of
	 * this class exists in memory at any given time.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return Sms_Net_Gr_Model
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) && ! ( self::$instance instanceof Sms_Net_Gr_Model ) ) {
			self::$instance = new Sms_Net_Gr_Model();
		}
		return self::$instance;
	}

	/**
	 * Function create_sms_net_gr_table
	 *
	 * Creates sms_net_gr table
	 *
	 * @since 1.0.0
	 * @access public
	 * @return void
	 */
	public function create_sms_net_gr_table() {
		global $wpdb;
		$charset_collate = $wpdb->get_charset_collate();
		$sql = 'CREATE TABLE IF NOT EXISTS ' . $this->get_table_name() . " (
                   smsnet_id int(10) unsigned NOT NULL AUTO_INCREMENT,
                   send_tstamp datetime NOT NULL,
                   sender_id text NOT NULL,
                   `to` text NOT NULL,
                   message text NOT NULL,
                   status text NOT NULL,
                   status_tstamp datetime NOT NULL,
                   gsm_encoding binary NOT NULL,
                   order_id int(10) unsigned DEFAULT NULL,
                   PRIMARY KEY (smsnet_id)
                ) $charset_collate;";
		require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
		dbDelta( $sql );
		if ( $wpdb->last_error ){
			Sms_Net_Gr_Logger::instance()->log( $wpdb->last_error );
		}
	}

	/**
	 * Function create_sms_net_gr_table
	 *
	 * Deletes sms_net_gr table
	 *
	 * @since 1.0.0
	 * @access public
	 * @return void
	 */
	public function delete_sms_net_gr_table() {
		 global $wpdb;
		 $sql = 'DROP TABLE IF EXISTS ' . $this->get_table_name();
		  $wpdb->query( $sql );
		 if ( $wpdb->last_error ){
			 Sms_Net_Gr_Logger::instance()->log( $wpdb->last_error );
		 }
	}
}
