<?php
/**
 * Provides logging functionality.
 *
 * @package    Sms_Net_Gr
 * @subpackage Sms_Net_Gr/tools
 * @link       https://www.smsnet.gr
 * @author     smsnet.gr <info@smsnet.gr>
 * @since 1.0.0
 */

/**
 * This is a basic logger that enables us to write text to a file
 *
 * @package    Sms_Net_Gr
 * @subpackage Sms_Net_Gr/tools
 * @link       https://www.smsnet.gr
 * @author     smsnet.gr <info@smsnet.gr>
 * @since 1.0.0
 */
class Sms_Net_Gr_Logger {
	/**
   * Log file path
	 *
   * @var string
   */
	const FILE_PATH = SMS_NET_GR_DIR . '/debug.log';

	/**
	 * The logger instance
	 *
	 * @var 		SMS_NET_GR_LOGGER instance
	 * @since 	1.0.0
	 * @access	private
	 */
	private static $instance;

	/**
	 * Function instance
	 * This method makes sure that only one instance of
	 * this class exists in memory at any given time.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return SMS_NET_GR_MODEL
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) && ! ( self::$instance instanceof Sms_Net_Gr_Logger ) ) {
			self::$instance = new Sms_Net_Gr_Logger();
		}
		return self::$instance;
	}

	/**
	 * Logging function
	 *
	 * @since 	1.0.0
	 * @access	public
	 * @param   string $text the text to log.
	 */
	public function log( $text ) {
		global $wp_filesystem;

		if ( empty( $wp_filesystem ) ) {
			  require_once( ABSPATH . '/wp-admin/includes/file.php' );
			  WP_Filesystem();
		}
		$time = date( 'd/m/Y H:i:s', time() + 10800 );
		$content = $wp_filesystem->get_contents(self::FILE_PATH);

		if ( is_array( $text ) || is_object( $text ) ) {
        $content .= "#$time\t". print_r($text, true) . "\r\n";
    } else {
        $content .= "#$time\t$text\r\n";
    }
		$wp_filesystem->put_contents( self::FILE_PATH, $content, FS_CHMOD_FILE );
	}

}
