<?php
/**
 * Defines a class that inherits from abstract class
 * Sms_Net_Gr_Wc_Base
 *
 * @package    Sms_Net_Gr
 * @subpackage Sms_Net_Gr/woocommerce
 * @link       https://www.smsnet.gr
 * @author     smsnet.gr <info@smsnet.gr>
 * @since 1.0.0
 */

require_once dirname( __FILE__ ) . '/class-sms-net-gr-wc-base.php';

/**
 * Class Sms_Net_Gr_Wc_base inherits from Sms_Net_Gr_Api_Base
 * and it is a singleton.
 *
 * @package    Sms_Net_Gr
 * @subpackage Sms_Net_Gr/woocommerce
 * @link       https://www.smsnet.gr
 * @author     smsnet.gr <info@smsnet.gr>
 * @since 1.0.0
 */
class Sms_Net_Gr_Wc extends Sms_Net_Gr_Wc_Base {
  /**
	 * The plugin instance
	 *
	 * @var Sms_Net_Gr_Wc instance
	 * @since 1.0.0
	 */
	private static $instance;

	/**
	 * Constructor
	 *
	 * @since 1.0.0
	 * @access private
	 * @return void
	 */
	protected function __construct() {
 		parent::__construct();
 	}

	/**
	 * Function instance
	 * This method makes sure that only one instance of
	 * this class exists in memory at any given time.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return Sms_Net_Gr_Wc
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) && ! ( self::$instance instanceof Sms_Net_Gr_Wc ) ) {
			self::$instance = new Sms_Net_Gr_Wc();
		}
		return self::$instance;
	}
}
