<?php
/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://www.smsnet.gr
 * @since             1.0.0
 * @package           Sms_Net_Gr
 *
 * @wordpress-plugin
 * Plugin Name:       SMSnet SMS Plugin for WooCommerce
 * Plugin URI:        https://www.smsnet.gr
 * Description:       This is a plugin for WooCommerce developed by smsnet.gr.
 * Version:           1.0.0
 * Author:            smsnet.gr
 * Author URI:        https://www.smsnet.gr
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       sms-net-gr
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-sms-net-gr-activator.php
 *
 * @since    1.0.0
 */
function activate_sms_net_gr() {
	if( class_exists( 'WooCommerce' ) ) {
		require_once plugin_dir_path( __FILE__ ) . 'includes/class-sms-net-gr-activator.php';
		Sms_Net_Gr_Activator::activate();
	} else {
		woocommerce_not_installed_or_deactivated();
	}
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-sms-net-gr-deactivator.php
 *
 * @since    1.0.0
 */
function deactivate_sms_net_gr() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-sms-net-gr-deactivator.php';
	Sms_Net_Gr_Deactivator::deactivate();
}

/**
 * Sets a transient message which fires plugin deactivation
 *
 * @since    1.0.0
 */
function woocommerce_not_installed_or_deactivated() {
	set_transient('wc-not-installed-or-deactivated-admin-notice', true, 5);
}

register_activation_hook( __FILE__, 'activate_sms_net_gr' );
register_deactivation_hook( __FILE__, 'deactivate_sms_net_gr' );

// Deactivate plugin on WooCommerce deactivation
register_deactivation_hook( 'woocommerce/woocommerce.php', 'woocommerce_not_installed_or_deactivated' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-sms-net-gr.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_sms_net_gr() {

	$plugin = new Sms_Net_Gr();
	$plugin->run();

}
// Run the Plugin.
run_sms_net_gr();
